#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <windows.h>
#include "resource.h"
  
double const PI = 3.14159265358979323846;

HINSTANCE dllInstance;

#define MAX_BUFFER_LENGTH		256			// in number of samples

class COOERecorder {
public:
	virtual bool __cdecl Init();

	virtual bool __cdecl IsMultiTrack();
	virtual bool __cdecl IsTagged();
	virtual bool __cdecl IsStreamed();
	virtual bool __cdecl IsRequiresWaveout();
	virtual bool __cdecl IsLossyCompression();

	virtual bool __cdecl IsSampleRateChangeable();
	virtual bool __cdecl SampleRateChanged(int samplerate);
	virtual bool __cdecl IsBitRateChangeable();
	virtual bool __cdecl BitRateChanged(int bitrate);

	virtual bool __cdecl SupportsSampleRate(int samplerate);
	virtual bool __cdecl SupportsBitRate(int bitrate);

	virtual bool __cdecl SaveAs(HWND parentwindow);
	virtual bool __cdecl ReadyToRec();

	virtual bool __cdecl TrackNames(int track_id, char *track_name);
	virtual bool __cdecl SongTagData(int tag_index, char *tagdata);

    virtual bool __cdecl Start(char * filename, int samplespersec);
    virtual bool __cdecl WorkOutput(float *psamples, int numsamples);
	virtual bool __cdecl WorkOutputMulti(int track_id, float *psamples, int numsamples);

    virtual bool __cdecl Finish();
    virtual void __cdecl ConfigDlg(HWND parentwindow);
	virtual void __cdecl DispatchCommand(int command_id, int param1, int param2, int param3, int param4);
	virtual void __cdecl DispatchCommandEx(char * str_command, char * str_value);

	virtual void __cdecl LoadSettings(char * settingsname, char *username, char *domain);
	virtual void __cdecl SaveSettings(char * settingsname, char *username, char *domain);

	virtual char * __cdecl OutputFilename();
    virtual char * __cdecl OutputSize();
	virtual char * __cdecl ExtraInfo(int extra_info_id);
	virtual char * __cdecl RecordersWebSiteURL();

	virtual int __cdecl RecorderVersion();

	virtual void GetRecorderExtensionsClass(int param, void **exmodule);
};

class rec : public COOERecorder {
public:
	virtual bool __cdecl Init();

	virtual bool __cdecl IsMultiTrack() { return true; };
	virtual bool __cdecl IsTagged() { return false; };
	virtual bool __cdecl IsStreamed() { return false; };
	virtual bool __cdecl IsRequiresWaveout() { return false; };
	virtual bool __cdecl IsLossyCompression() { return false; };

	virtual bool __cdecl IsSampleRateChangeable() { return false; };
	virtual bool __cdecl SampleRateChanged(int samplerate) { return false; };
	virtual bool __cdecl IsBitRateChangeable() { return false; };
	virtual bool __cdecl BitRateChanged(int bitrate) { return false; };

	virtual bool __cdecl SupportsSampleRate(int samplerate) { return true; };
	virtual bool __cdecl SupportsBitRate(int bitrate) { return true; };

	virtual bool __cdecl SaveAs(HWND parentwindow);
	virtual bool __cdecl ReadyToRec();

	virtual bool __cdecl TrackNames(int track_id, char *track_name);
	virtual bool __cdecl SongTagData(int tag_index, char *tagdata) { return false; };

    virtual bool __cdecl Start(char * filename, int samplespersec);
    virtual bool __cdecl WorkOutput(float *psamples, int numsamples);
	virtual bool __cdecl WorkOutputMulti(int track_id, float *psamples, int numsamples);

    virtual bool __cdecl Finish();
    virtual void __cdecl ConfigDlg(HWND parentwindow);
	virtual void __cdecl DispatchCommand(int command_id, int param1, int param2, int param3, int param4);
	virtual void __cdecl DispatchCommandEx(char * str_command, char * str_value);

	virtual void __cdecl LoadSettings(char * settingsname, char *username, char *domain) { };
	virtual void __cdecl SaveSettings(char * settingsname, char *username, char *domain) { };

	virtual char * __cdecl OutputFilename();
    virtual char * __cdecl OutputSize();
	virtual char * __cdecl ExtraInfo(int extra_info_id) { return "No Extra Info"; };
	virtual char * __cdecl RecordersWebSiteURL() { return "http://www.buzzscene.ca/"; };

	virtual int __cdecl RecorderVersion() { return 100; };

	virtual void GetRecorderExtensionsClass(int param, void **exmodule) { };
public:
	char myfilename[MAX_PATH];
	char tracknames[65][100];
	char trackused[65];
	FILE * myfilehandle[65];
	unsigned int writtensofar[65];
//	int bitdepth;
};

bool rec::Init(){
	int i;
	sprintf(myfilename, "");
	writtensofar[64] = 0;
	trackused[64] = 1;
	myfilehandle[64] = NULL;
	for (i = 0; i < 64; i++) {
		myfilehandle[i] = NULL;
		writtensofar[i] = 0;
		trackused[i] = 0;
		sprintf(tracknames[i], "");
	}
	return true;
}

bool rec::TrackNames(int track_id, char *track_name) {
	trackused[track_id] = 1;
	sprintf(tracknames[track_id], track_name);
	return true;
}

bool rec::SaveAs(HWND parentwindow) {
	OPENFILENAME ofl;
	char filename[255];
	int nSuccess;

	sprintf(filename,"Base Filename.raw");
	ofl.lStructSize = sizeof(ofl);
	ofl.hwndOwner = parentwindow;
	ofl.hInstance = dllInstance;
	ofl.lpstrFilter = "Raw 16-bit data (*.raw)\0*.raw\0";
	ofl.lpstrCustomFilter = NULL;
	ofl.nMaxCustFilter = NULL;
	ofl.nFilterIndex = 1;
	ofl.lpstrFile = filename;
	ofl.nMaxFile = 255;
	ofl.lpstrFileTitle = NULL;
	ofl.nMaxFileTitle = NULL;
	ofl.lpstrInitialDir = NULL;
	ofl.lpstrTitle = "Save Base Filename Output as";
	ofl.Flags = OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST;
	ofl.nFileOffset = 0;
	ofl.nFileExtension = 0;
	ofl.lpstrDefExt = ".raw";
	ofl.lCustData = NULL;
	ofl.lpfnHook = NULL;
	ofl.lpTemplateName = NULL;
	nSuccess = GetSaveFileName(&ofl);
	if (nSuccess == 0) {
		sprintf(myfilename, "");
	} else {
		sprintf(myfilename, ofl.lpstrFile);
	}
	return true;
}
char *rec::OutputFilename() {
	return myfilename;
}
bool rec::Start (char * filename, int samplespersec) {
	char basefilename[256];
	char bufferfilen[256];
	int i;


	myfilehandle[64] = fopen(filename, "wb");
	writtensofar[64] = 0;

	sprintf(basefilename, filename);
	basefilename[strlen(filename) - 4] = 0;
	for (i = 0; i < 64; i++) {
		if (trackused[i] == 1) {
			sprintf(bufferfilen, "%s - %s.raw", basefilename, tracknames[i]);
			myfilehandle[i] = fopen(bufferfilen, "wb");
			writtensofar[i] = 0;
		}
	}

	for (i = 0; i < 65; i++) {
		if (trackused[i] == 1) {
			// stick stuff here for headers, raw files dont
			// have headers tho
		}
	}

	return true;
}
bool rec::ReadyToRec() {
	if (strcmp(myfilename, "") == 0) {
		return false;
	} else {
		return true;
	}

}

// This is whatever is outputed through the Track machines
bool rec::WorkOutputMulti(int track_id, float *psamples, int numsamples) {
	short psampsm[1024];
	for (int i = 0; i < (numsamples * 2); i++) {
		if (psamples[i] > 32767.0f) psamples[i] = 32767.0f;
		if (psamples[i] < -32766.0f) psamples[i] = -32766.0f;
		psampsm[i] = (short)psamples[i];
	}
	writtensofar[track_id] += numsamples;
	fwrite(psampsm, sizeof(short), numsamples * 2,myfilehandle[track_id]);
	return true;
}

// This is whatever gets outputed through the Master machine
bool rec::WorkOutput (float *psamples, int numsamples) {
	short psampsm[1024];
	for (int i = 0; i < (numsamples * 2); i++) {
		if (psamples[i] > 32767.0f) psamples[i] = 32767.0f;
		if (psamples[i] < -32766.0f) psamples[i] = -32766.0f;
		psampsm[i] = (short)psamples[i];
	}
	writtensofar[64] += numsamples;
	fwrite(psampsm, sizeof(short), numsamples * 2,myfilehandle[64]);
	return true;
}

bool rec::Finish() {
	int i;
	for (i = 0; i < 65; i++) {
		if (trackused[i] == 1) {
			// write your footer for each file here
			// raw files dont have footers tho

			fflush(myfilehandle[i]);
			fclose(myfilehandle[i]);
		}
	}
	return true;
}

char * rec::OutputSize() {
	static char megs[32];
	sprintf(megs, "%.2fM", ((float)writtensofar[64] * 4.0f / 1024.0f / 1024.0f));
	return megs;
}

rec *prec;

BOOL APIENTRY ConfigDialog (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_INITDIALOG:
	{
		return 1;
	}
	case WM_SHOWWINDOW:
	{
		return 1;
	}
	case WM_CLOSE:
	{
		EndDialog (hDlg, TRUE);
	}
	case WM_COMMAND:
		switch ( LOWORD (wParam))
		{
		case IDOK:
			EndDialog (hDlg, TRUE);
			break;
		case IDCANCEL:
			EndDialog (hDlg, TRUE);
			break;
		default:
			return 0;
		}
		break;
	}
	return 0;
}

BOOL APIENTRY AboutDialog (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_INITDIALOG:
	{
		return 1;
	}
	case WM_SHOWWINDOW:
	{
		return 1;
	}
	case WM_CLOSE:
	{
		EndDialog (hDlg, TRUE);
	}
	case WM_COMMAND:
		switch ( LOWORD (wParam))
		{
		case IDOK:
			EndDialog (hDlg, TRUE);
			break;
		case IDCANCEL:
			EndDialog (hDlg, TRUE);
			break;
		default:
			return 0;
		}
		break;
	}
	return 0;
}

void rec::ConfigDlg (HWND parentwindow) {
	prec = this;
	DialogBox(dllInstance, MAKEINTRESOURCE (IDD_CONFIG), parentwindow, (DLGPROC) &ConfigDialog);
}

void rec::DispatchCommand(int command_id, int param1, int param2, int param3, int param4) {

}

void rec::DispatchCommandEx(char * str_command, char * str_value) { 
	if (strcmp(str_command, "about") == 0) {
		HWND parentwindow = *(HWND*)str_value;
		DialogBox(dllInstance, MAKEINTRESOURCE (IDD_ABOUTBOX), parentwindow, (DLGPROC) &AboutDialog);
	}
}

extern "C" {
__declspec(dllexport) COOERecorder * __cdecl CreateRecorder() { return new rec; }
__declspec(dllexport) char * __cdecl RecInfo() { return "Multitrack Raw Recorder by CyanPhase"; }
}

BOOL WINAPI DllMain ( HANDLE hModule, DWORD fwdreason, LPVOID lpReserved )
{
	switch (fwdreason) {
	case DLL_PROCESS_ATTACH: { dllInstance = (HINSTANCE) hModule; } break;
	case DLL_THREAD_ATTACH: break;
	case DLL_THREAD_DETACH: break;
	case DLL_PROCESS_DETACH: break;
	}
	return TRUE;
}
